<!DOCTYPE html>
<html>
  <head>
    <title>$.geocomplete()</title>
    <meta charset="UTF-8">
    <link rel="stylesheet" type="text/css" href="examples/styles.css" />
    <style type="text/css" media="screen">
      form { width: 300px; float: left; margin-left: 20px}
      
      fieldset { width: 320px; margin-top: 20px}
      fieldset strong { display: block; margin: 0.5em 0 0em; }
      fieldset input { width: 95%; }
      
      ul span { color: #999; }
    </style>
  </head>
  <body>
    
    <div class="map_canvas"></div>
    
    <form>
      <input id="geocomplete" type="text" placeholder="Type in an address" value="111 Broadway, New York, NY" />
      <input id="find" type="button" value="find" />
      
      <fieldset>
        <label>Latitude</label>
        <input name="lat" type="text" value="">
      
        <label>Longitude</label>
        <input name="lng" type="text" value="">
      
        <label>Formatted Address</label>
        <input name="formatted_address" type="text" value="">
      </fieldset>
      
      <a id="reset" href="#" style="display:none;">Reset Marker</a>
    </form>

    <script src="http://maps.googleapis.com/maps/api/js?key=AIzaSyAineIYQ9JLcxRfT9yLd_FKuGHz5-FFsk4&sensor=false&amp;libraries=places"></script>
    <script src="http://ajax.googleapis.com/ajax/libs/jquery/1.7.1/jquery.min.js"></script>
    
    <script src="jquery.geocomplete.js"></script>
    
    <script>
      $(function(){
        $("#geocomplete").geocomplete({
          map: ".map_canvas",
          details: "form ",
          markerOptions: {
            draggable: true
          }
        });
        
        $("#geocomplete").bind("geocode:dragged", function(event, latLng){
          $("input[name=lat]").val(latLng.lat());
          $("input[name=lng]").val(latLng.lng());
          $("#reset").show();
        });
        
        
        $("#reset").click(function(){
          $("#geocomplete").geocomplete("resetMarker");
          $("#reset").hide();
          return false;
        });
        
        $("#find").click(function(){
          $("#geocomplete").trigger("geocode");
        }).click();
      });
    </script>
    
  </body>
</html>

