<?php

  $Position   = '../../';
  require_once($Position.'config/config.php');
  require_once($Position.'config/conexion.php');
  require_once($Position.'config/user.php');
  require_once($Position.'funciones/acces.php');
  require_once($Position.'funciones/logout.php');
  require_once($Position.'funciones/funciones.php');
  require_once($Position.'funciones/extras.php');

  $Where = "
    WHERE
      ven.Id != '0'
  ";

  if( $_GET['Filtrar'] == 'Ok' ){

    $Bus = '?Filtrar=Ok';

    $FechaDesde = CambioFechaCompleta($_GET['Desde']);
    $Bus .= "&Desde=".$_GET['Desde'];

    $FechaHasta = CambioFechaCompleta($_GET['Hasta']);
    $Bus .= "&Hasta=".$_GET['Hasta'];

    //Cliente
    if( $_GET['Cliente'] ){
      $FilCli = $_GET['Cliente'];
      $Where .= "
        AND cli.Nombre LIKE '$FilCli%'
      ";
      $Bus .= "&Cliente=".$FilCli;
    }
    //End Cliente

    //Metodo de Pago
    if( $_GET['Metodo'] ){
      $FilMet = $_GET['Metodo'];
      $Left .= "
        LEFT JOIN KB_Pagos pag ON pag.Fk_Venta = ven.Id
      ";
      $Where .= "
        AND pag.Fk_Metodo = '$FilMet'
      ";
      $Bus .= "&Metodo=".$FilMet;
    }
    //End Metodo de Pago

  }else{
    $FechaDesde = date('Y-m-01');
    $FechaHasta = date('Y-m-t');
  }

  $Where .= "
    AND (ven.Fecha BETWEEN '".$FechaDesde." 00:00:00' AND '".$FechaHasta." 23:59:59' )
  ";

  $FilDes = CambioFechaInversa($FechaDesde);
  $FilHas = CambioFechaInversa($FechaHasta);
  //End Buscador

  //Ventas
  $Query = "
    SELECT
      ven.Id,
      ven.Folio,
      ven.Documento,
      ven.Sucursal,
      ven.Fecha,
      ven.Total,
      ven.FechaCarga,
      emp.Nombre AS Empresa,
      cli.Nombre AS Cliente
    FROM KB_Ventas ven
    LEFT JOIN KB_Empresas emp ON emp.Id = ven.Fk_Empresa
    LEFT JOIN KB_Clientes cli ON cli.Id = ven.Fk_Cliente
    $Left
      $Where
    ORDER BY ven.Fecha DESC
  ";
  $Ventas = $mysqli->query($Query);


  header("Content-Type: application/vnd.ms-excel; charset=utf-8");
  header("Content-Disposition: attachment; filename=ventas-productos.xls");
  header("Expires: 0");
  header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
  header("Cache-Control: private",false);

  // header('Content-Type: application/vnd.ms-Excel');
  // header('Content-Disposition: attachment;filename="ventas.xls"');
  // header('Cache-Control: max-age=0');

?>
<table>
  <thead>
    <tr>
      <th>Clave</th>
      <th>Fecha</th>
      <th>Hora</th>
      <th>Tipo</th>
      <th>Cliente</th>
      <th>Clave Producto</th>
      <th>Producto</th>
      <th>Cantidad</th>
      <th>Precio</th>
      <th>Total</th>
    </tr>
  </thead>
  <tbody>
    <?php
      //Ventas
      mysqli_data_seek($Ventas, 0);
      while($Ven = mysqli_fetch_array($Ventas)) {
    ?>
      <?php
        //Productos
        $Query = "
          SELECT
            pro.Id,
            pro.ProductoClave,
            pro.Cantidad,
            pro.Precio,
            pro.Descuento,
            pro.Total,
            pr.Nombre
          FROM KB_VentasProductos pro
          LEFT JOIN KB_Productos pr ON pr.Clave = pro.ProductoClave
            WHERE pro.Fk_Venta = '$Ven[Id]'
          ORDER BY pro.Id DESC
        ";
        $Items = $mysqli->query($Query);
        mysqli_data_seek($Items, 0);
        while($Item = mysqli_fetch_array($Items)) {
      ?>
        <tr>

          <!-- Documento -->
          <td>
            <?php echo $Ven['Documento']; ?>
          </td>
          <!-- End Documento -->

          <!-- Fecha -->
          <td>
            <?php echo CambioFechaInversa(date('Y-m-d', strtotime($Ven['Fecha']))); ?>
          </td>
          <!-- End Fecha -->

          <!-- Hora -->
          <td>
            <?php echo date('H:i', strtotime($Ven['Fecha'])); ?>
          </td>
          <!-- End Hora -->

          <!-- Tipo -->
          <td>
            <?php
              if( $Ven['FechaCarga'] ){
                echo 'Externa';
              }else{
                echo 'Interna';
              }
            ?>
          </td>
          <!-- End Tipo -->

          <!-- Cliente -->
          <td>
            <?php echo $Ven['Cliente']; ?>
          </td>
          <!-- End Cliente -->

          <!-- ProductoClave -->
          <td>
            <?php echo $Item[ProductoClave]; ?>
          </td>
          <!-- End ProductoClave -->

          <!-- Nombre Producto -->
          <td>
            <?php echo $Item[Nombre]; ?>
          </td>
          <!-- End Nombre Producto -->

          <!-- Cantidad -->
          <td style="width:100px;" class="text-right">
            <?php echo $Item[Cantidad]; ?>
          </td>
          <!-- End Cantidad -->

          <!-- Precio -->
          <td style="width:100px;" class="text-right">
            <?php echo $Item[Precio]; ?>
          </td>
          <!-- End Precio -->

          <!-- Total -->
          <td style="width:100px;" class="text-right">
            <?php
              $TotalProductos = $TotalProductos + $Item['Total'];
              echo number_format($Item['Total'],2,'.',',');
            ?>
          </td>
          <!-- End Total -->

        </tr>
      <?php } ?>
    <?php } ?>
  </tbody>
