<?php
  $Seccion    = 'Venta';
  $Position   = '../';

  $NameSec      = 'Venta';
  $SecLine      = array('Venta');

  require_once($Position.'config/config.php');
  require_once($Position.'config/conexion.php');
  require_once($Position.'config/user.php');
  require_once($Position.'funciones/acces.php');
  require_once($Position.'funciones/logout.php');
  require_once($Position.'funciones/funciones.php');
  require_once($Position.'funciones/extras.php');

  $ProdSelectOpc = '2';

?>

<!DOCTYPE html>
<html lang="en">

<?php require_once($Position.'head.php'); ?>

<body class="fix-sidebar fix-header card-no-border">
    <div class="preloader">
        <svg class="circular" viewBox="25 25 50 50">
            <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10" /> </svg>
    </div>
    <div id="main-wrapper">
      <?php require_once($Position.'header.php'); ?>
      <?php require_once($Position.'menu.php'); ?>
      <div class="page-wrapper">
        <div class="container-fluid">
          <form method="post" enctype="multipart/form-data" data-validate="parsley" role="form" id="FormPer">

            <div class="row page-titles">

              <?php require_once($Position.'title.php'); ?>

              <!-- Botones -->
              <div class="col-md-7 align-self-center text-right">
                <div class="btn-group" role="group" aria-label="Basic example">
                  <?php if( $Perms[2] ){ ?>
                    <a href="edit.php">
                      <button type="button" class="btn btn-sm btn-secondary">Nuevo<i class="fa fa-plus mar-l-10"></i></button>
                    </a>
                  <?php } ?>
                </div>
              </div>
              <!-- End Botones -->

            </div>

            <div class="row">
              <div class="col-12">

                <!-- Card Productos -->
                <div class="card">
                  <div class="card-body">

                    <h3>Productos</h3>
                    <hr>

                    <div class="row">

                      <?php if( $ProdSelectOpc == '2' ){ ?>

                        <!-- Categorias -->
                        <div class="col-sm-12 form-group">
                          <label>Categoría</label>
                          <select
                            class="demo-default chosen-select BtnFillCat"
                            data-required="true"
                          >
                            <option value="">Todas</option>
                            <?php
                              //Productos
                              $Query = "
                                SELECT
                                  cat.Id,
                                  cat.Clave, cat.Nombre
                                FROM KB_Productos_Categorias cat
                                WHERE
                                  cat.Id != '0'
                              ";
                              $Cats = $mysqli->query($Query);
                              mysqli_data_seek($Cats, 0);
                              while($Cat = mysqli_fetch_array($Cats)) {
                            ?>
                              <option
                                value="<?php echo $Cat['Id']; ?>"
                              ><?php echo $Cat['Clave']; ?></option>
                            <?php } ?>
                          </select>
                        </div>
                        <!-- End Productos -->

                        <!-- Productos -->
                        <div class="col-sm-12 form-group">
                          <label>Producto</label>
                          <select
                            class="demo-default chosen-select BtnFillSel"
                            data-required="true"
                          >
                            <option value=""></option>
                            <?php
                              //Productos
                              $Query = "
                                SELECT
                                  pro.Id,
                                  pro.Clave, pro.Nombre, pro.Descripcion,
                                  pro.ClaveCategoria,
                                  pro.ClaveSubCategoria,
                                  pro.ClaveMarca,
                                  pro.Existencia,
                                  pro.UnidadesCompletas,
                                  pro.Alto, pro.Ancho, pro.Largo, pro.Peso,
                                  pro.Precio, pro.Descuento,
                                  pro.Barcode, pro.VentaApp, pro.Activo
                                FROM KB_Productos pro
                                WHERE
                                  pro.Activo = '1'
                                  AND pro.VentaApp = '1'
                              ";
                              $Pros = $mysqli->query($Query);
                              mysqli_data_seek($Pros, 0);
                              while($Pro = mysqli_fetch_array($Pros)) {
                            ?>
                              <option
                                value="<?php echo $Pro['Id']; ?>"
                              ><?php echo $Pro['Clave']; ?></option>
                            <?php } ?>
                          </select>
                        </div>
                        <!-- End Productos -->

                        <!-- Btn Add Producto -->
                        <div class="col-sm-12 BtnFillProd">
                          <button
                            data-clav=""
                            data-id=""
                            data-clave=""
                            data-nombre=""
                            data-precio=""
                            data-comision=""
                            data-existencia=""
                            type="button"
                            disabled="disabled"
                            class="BtnOpc btn btn-block btn-secondary"
                          >
                            Agregar Producto
                          </button>
                        </div>
                        <!-- End Btn Add Producto -->

                      <?php } ?>

                      <?php if( $ProdSelectOpc == '1' ){ ?>

                        <?php

                          //Productos
                          $Query = "
                            SELECT
                              pro.Id,
                              pro.Clave, pro.Nombre, pro.Descripcion,
                              pro.ClaveCategoria,
                              pro.ClaveSubCategoria,
                              pro.ClaveMarca,
                              pro.Existencia,
                              pro.UnidadesCompletas,
                              pro.Alto, pro.Ancho, pro.Largo, pro.Peso,
                              pro.Precio, pro.Descuento,
                              pro.Barcode, pro.VentaApp, pro.Activo
                            FROM KB_Productos pro
                            WHERE
                              pro.Activo = '1'
                              AND pro.VentaApp = '1'
                          ";
                          $Pros = $mysqli->query($Query);
                          mysqli_data_seek($Pros, 0);
                          while($Pro = mysqli_fetch_array($Pros)) {

                        ?>
                          <div class="col-6 col-sm-4 m-b-20">
                            <button
                              data-clav="<?php echo $Pro[Clave]; ?>"
                              data-id="<?php echo $Pro[Id]; ?>"
                              data-clave="<?php echo $Pro[Clave]; ?>"
                              data-nombre="<?php echo $Pro[Nombre]; ?>"
                              data-precio="<?php echo $Pro[Precio]; ?>"
                              data-comision="<?php echo $Comision[Comision]; ?>"
                              data-existencia="<?php echo $Pro[Existencia]; ?>"
                              type="button"
                              <?php if( $Pro[Existencia] <= 0 ){ echo "disabled"; } ?>
                              class="BtnOpc btn btn-block btn-secondary"
                            >
                              <?php echo $Pro[Clave]; //echo $Pro[Existencia]; ?>
                            </button>
                          </div>
                        <?php } ?>

                      <?php } ?>

                    </div>

                  </div>
                </div>
                <!-- End Card Productos -->

                <!-- Card Lista -->
                <div class="card">
                  <div class="card-body">

                    <div class="table-responsive m-t-20">
                      <table class="display nowrap table table-hover table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                          <tr>
                            <th>Nombre</th>
                            <th>Cantidad</th>
                            <th>Precio</th>
                            <th>Subtotal</th>
                            <td style="width:20px;"></td>
                          </tr>
                        </thead>
                        <tbody id="TableIn">
                          <tr>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                          </tr>
                        </tbody>
                        <tfoot>
                          <tr>
                            <td></td>
                            <td></td>
                            <th>Total</th>
                            <td>
                              <span id="TotalTab"></span>
                            </td>
                            <td></td>
                          </tr>
                        </tfoot>
                      </table>
                    </div>
                  </div>
                </div>
                <!-- End Card Lista -->

                <div class="row">
                  <div class="col-12">

                    <!-- Btn Continuar -->
                    <button
                      id="BtnContinuar"
                      style="display:none;"
                      type="button"
                      class="btn btn-block btn-success"
                      >
                        Continuar
                        <i class="fa fa-check"></i>
                      </button>
                    <!-- End Btn Continuar -->

                  </div>
                </div>

                <!-- Modal Pago -->
                <div id="Modal-Pago" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
                  <div class="modal-dialog">
                    <div class="modal-content">
                      <div class="modal-header">
                        <h4 class="modal-title" id="myModalLabel">Pago</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                      </div>
                      <div class="modal-body">
                        <div class="row">

                          <!-- Almacen -->
                          <input type="hidden" name="Almacen" value="<?php echo $User[Id]; ?>" />
                          <!-- End Almacen -->

                          <!-- UsuarioDep -->
                          <?php
                            $Query = "
                              SELECT
                                dep.Id, dep.Fk_userA, dep.Fk_userB
                              FROM users_dependencia dep
                              WHERE dep.Fk_userB = '$User[Id]'
                            ";
                            $Result = mysqli_query($mysqli, $Query);
                            $Dep = mysqli_fetch_assoc($Result);
                          ?>
                          <input type="hidden" name="UsuarioDep" value="<?php echo $Dep[Fk_userA]; ?>" />
                          <!-- End UsuarioDep -->

                          <!-- Cliente -->
                          <div class="col-sm-12 form-group">
                            <label>Cliente</label>
                            <select
                              id="Cliente"
                              name="Cliente"
                              class="demo-default chosen-select"
                              data-required="true"
                            >
                              <option value="0">Selecciona un Cliente</option>
                              <option value="NUEVO">NUEVO CLIENTE</option>
                              <?php
                                //Clientes
                                $Query = "
                                  SELECT
                                    cli.Id,
                                    cli.Clave, cli.Nombre, cli.Rfc
                                  FROM KB_Clientes cli
                                  ORDER BY cli.Nombre ASC
                                ";
                                $Clientes = $mysqli->query($Query);
                                mysqli_data_seek($Clientes, 0);
                                while($Cli = mysqli_fetch_array($Clientes)) {
                              ?>
                                <option
                                  value="<?php echo $Cli['Id']; ?>"
                                  <?php if( $Cli['Id'] == '1' ){ ?>
                                    selected="selected"
                                  <?php } ?>
                                ><?php echo $Cli['Nombre']; ?> - <?php echo $Cli['Rfc']; ?></option>
                              <?php } ?>
                            </select>
                          </div>
                          <!-- End Cliente -->

                          <!-- Email -->
                          <div class="col-sm-12 form-group">
                            <label>Email</label>
                            <input
                              autocomplete="off"
                              class="form-control EmailSel"
                              name="Email"
                              data-required="true"
                              data-type="email"
                              oninput="this.value=this.value.toLowerCase()"
                            />
                          </div>
                          <!-- Email -->

                          <!-- Total -->
                          <div class="col-sm-12 form-group">
                            <label>Total</label>
                            <input
                              readonly
                              id="Total"
                              class="form-control"
                              id="Total"
                              name="Total"
                              data-type="number"
                            />
                          </div>
                          <!-- End Total -->

                          <!-- Metodos de Pago -->
                          <div class="col-sm-12 form-group">
                            <hr>
                            <label>Métodos de Pago</label>

                            <div class="form-group MetodosPagos">

                            </div>

                            <div>
                              <!-- Btn Agregar Metodo de Pago -->
                              <button
                                class="btn btn-secondary Btn-AddMetodoPago"
                                type="button"
                              >
                                Agregar Método de Pago
                              </button>
                              <!-- End Btn Agregar Metodo de Pago -->
                            </div>

                            <hr>

                          </div>
                          <!-- End Metodos de Pago -->

                          <!-- Pago -->
                          <div class="col-sm-12 form-group">
                            <label>Pago</label>
                            <input
                              autocomplete="off"
                              data-type="number"
                              class="form-control PagoFull"
                              name="PagoFull"
                              data-type="number"
                              inputmode="numeric"
                              readonly
                            />
                          </div>
                          <!-- End Pago -->

                          <!-- Deuda -->
                          <div class="col-sm-12 form-group">
                            <label>Deuda</label>
                            <input
                              readonly
                              id="Deuda"
                              class="form-control"
                              id="Deuda"
                              name="Deuda"
                              data-type="number"
                            />
                          </div>
                          <!-- End Deuda -->

                          <!-- Pago Observaciones -->
                          <div class="col-sm-12 form-group">
                            <hr>
                            <label>Observaciones</label>
                            <textarea class="form-control" maxlength="60" data-maxlength="60" name="Observaciones"></textarea>
                          </div>
                          <!-- End Observaciones -->

                        </div>
                      </div>
                      <div class="modal-footer">
                        <div style="width:100%;display:none;" class="CardErrorA">
                          <div class="card card-danger">
                            <div class="card-body">
                              <h4 style="color: #fff;margin-bottom: 0px;">Error!</h4>
                              <p style="color:#fff;margin-bottom: 0px;">
                                ¡ No se puede pagar más del Total !
                              </p>
                            </div>
                          </div>
                        </div>
                        <div>
                          <input type="hidden" name="Save" value="Ok" />
                          <button type="button" class="btn btn-success BtnGuardar">Guardar</button>
                          <button type="button" class="btn btn-secondary waves-effect" data-dismiss="modal">Cancelar</button>
                        </div>
                      </div>
                    </div>
                    <!-- /.modal-content -->
                  </div>
                  <!-- /.modal-dialog -->

                </div>
                <!-- Modal Pago -->

              </div>
            </div>

          </form>
        </div>

        <!-- Modal Nuevo Cliente -->
        <form method="post" enctype="multipart/form-data" data-validate="parsley" role="form" id="Form-Cliente">
          <div id="Modal-NuevoCliente" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
            <div class="modal-dialog">
              <div class="modal-content">
                <div class="modal-header">
                  <h4 class="modal-title" id="myModalLabel">Nuevo Cliente</h4>
                  <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                </div>
                <!-- Modal Body -->
                <div class="modal-body">
                  <div class="row">

                    <!-- Nombre -->
                    <div class="col-sm-12 form-group">
                      <label>Nombre</label>
                      <input
                        autocomplete="off"
                        class="form-control"
                        name="Nombre"
                        data-required="true"
                      />
                    </div>
                    <!-- End Nombre -->

                    <!-- Pasaporte -->
                    <div class="col-sm-12 form-group">
                      <label>Pasaporte</label>
                      <input
                        autocomplete="off"
                        class="form-control"
                        name="Pasaporte"
                        data-required="true"
                      />
                    </div>
                    <!-- End Pasaporte -->

                    <!-- RFC -->
                    <div class="col-sm-12 form-group">
                      <label>RFC</label>
                      <input
                        autocomplete="off"
                        class="form-control"
                        name="Rfc"
                        data-required="true"
                      />
                    </div>
                    <!-- End RFC -->

                    <!-- Fecha Nacimiento -->
                    <div class="col-sm-12 form-group">
                      <label>Fecha de Nacimiento</label>
                      <input
                        autocomplete="off"
                        class="form-control datepicker-year"
                        name="FechaNacimiento"
                        data-required="true"
                      />
                    </div>
                    <!-- End Fecha Nacimiento -->

                    <!-- Telefono -->
                    <div class="col-sm-12 form-group">
                      <label>Teléfono</label>
                      <input
                        autocomplete="off"
                        class="form-control"
                        name="Telefono"
                        data-required="true"
                      />
                    </div>
                    <!-- End Telefono -->

                    <!-- Email -->
                    <div class="col-sm-12 form-group">
                      <label>Email</label>
                      <input
                        autocomplete="off"
                        class="form-control"
                        name="Email"
                        data-required="true"
                        data-type="email"
                        oninput="this.value=this.value.toLowerCase()"
                      />
                    </div>
                    <!-- End Email -->

                    <!-- Uso de CFDI -->
                    <div class="col-sm-12 form-group">
                      <label>Uso de CFDI</label>
                      <select
                        name="Uso"
                        class="demo-default chosen-select"
                        data-required="true"
                      >
                        <!-- <option>Selecciona una opción</option> -->
                        <?php
                          //Usos CFDI
                          $Query = "
                            SELECT
                              uso.Id, uso.Clave, uso.Uso
                            FROM KB_FacturasUsos uso
                            WHERE uso.Activo = '1'
                            ORDER BY uso.Id ASC
                          ";
                          $Usos = $mysqli->query($Query);
                          mysqli_data_seek($Usos, 0);
                          while($Uso = mysqli_fetch_array($Usos)) {
                        ?>
                          <option
                            value="<?php echo $Uso['Id']; ?>"
                            <?php if( $Uso[Id] == '1' ){ ?>
                              selected="selected"
                            <?php } ?>
                            ><?php echo $Uso['Clave']; ?> - <?php echo $Uso['Uso']; ?></option>
                        <?php } ?>
                      </select>
                    </div>
                    <!-- End Uso de CFDI -->

                  </div>
                </div>
                <!-- End Modal Body -->
                <!-- Moidal Foot -->
                <div class="modal-footer">
                  <input type="hidden" name="Save-Cliente" value="Ok" />
                  <button type="button" class="btn btn-success Btn-SaveCliente">Guardar</button>
                  <button type="button" class="btn btn-secondary waves-effect" data-dismiss="modal">Cancelar</button>
                </div>
                <!-- End Modal Foot -->
              </div>
            </div>
          </div>
        </form>
        <!-- End Modal Nuevo Cliente -->

        <?php require_once($Position.'footer.php'); ?>
      </div>
    </div>

    <?php require_once($Position.'scripts.php'); ?>

    <script>

      $( document ).ready(function() {

        $(document.body).on('change', '#Cliente' ,function(){
          val = $(this).val();

          var selected = $(this).find('option:selected');
          var ema = selected.data('email');
          // ema = $(this).data('email');
          // console.log(ema);
          if( val == 'NUEVO' ){
            $("#Modal-Pago").modal('hide');
            $("#Modal-NuevoCliente").modal('show');
          }else{
            $('.EmailSel').val(ema);
          }
          console.log(val);
        });

        ConArt = 0;
        Lineas = 0;

        $('#FormPer').parsley();


        //Cateogria-Productos
        $(document.body).on('change', '.BtnFillCat' ,function(){

          val = $(this).val();
          console.log(val);

          $.post("productos.php", { go: 'ok', val: val }, function(data){
            console.log(data);
            if( data ){
              $('.BtnFillSel').html(data);
              $(".chosen-select").chosen();
              $('.chosen-select').trigger("chosen:updated");
              $('#FormPer').parsley();
            }
          });

        });
        //Emd Cateogria-Productos


        //Seleccion de Producto Select
        $(document.body).on('change', '.BtnFillSel' ,function(){

          val = $(this).val();
          console.log(val);

          $.post("btn-valproducto.php", { go: 'ok', val: val }, function(data){
            console.log(data);

            if( data ){

              $('.BtnFillProd').html(data);

            }

          });

        });
        //End Seleccion de Producto Select

        //Btn-SaveCliente
        $(document.body).on('click', '.Btn-SaveCliente' ,function(){

          $('#Form-Cliente').parsley();
          formulario = '#Form-Cliente';
          $(formulario).parsley().validate();
  				if( $(formulario).parsley().isValid() ){
						console.log('valid');
						swal({
							title: "¡Guardando datos!",
							text: "",
							showConfirmButton: false
						});

            var data = $(formulario).serializeArray();

            $.post("guardar-cliente.php", data,
            function(data){
              console.log(data);
              myObj = JSON.parse(data);

              if( myObj.action == 'saved' ){

                $(formulario)[0].reset();
                $('#Modal-NuevoCliente').modal('hide');

                swal({
                  title: "Guardado",
                  text: myObj.msn,
                  showConfirmButton: true
                }, function() {

                  action = 'show';
                  $.post("clientes.php", { action: action }, function(data){
                    $('#Cliente').html(data);
                    $(".chosen-select").chosen();
                    $('.chosen-select').trigger("chosen:updated");
                    $('#FormPer').parsley();
                    $('#Modal-Pago').modal('show');
                  });

                });

              }

              if( myObj.action == 'error' ){

                swal({
                  title: "Error",
                  text: myObj.msn,
                  showConfirmButton: true
                });

              }

            });

          } else {
  						console.log('not valid');
  						swal("", "Falta llenar algunos campos", "error");
  				}

        });
        //End Btn-SaveCliente

        //BtnGuardar
        $(document.body).on('click', '.BtnGuardar' ,function(){

          $('#FormPer').parsley();
          formulario = '#FormPer';
          $(formulario).parsley().validate();
  				if( $(formulario).parsley().isValid() ){
						console.log('valid');
						swal({
							title: "¡Guardando datos!",
							text: "",
							showConfirmButton: true
						});

            var data = $(formulario).serializeArray();

      			$.post("guardar-venta.php", data,
      			function(data){
      				console.log(data);
              myObj = JSON.parse(data);

              if( myObj.action == 'saved' ){

                $(formulario)[0].reset();
                swal({
                  title: "Guardado",
                  text: myObj.msn,
                  showConfirmButton: true
                }, function() {
                  window.location = "<?php echo $Position; ?>venta";
                });

              }

              if( myObj.action == 'error' ){

                swal({
                  title: "Error",
                  text: myObj.msn,
                  showConfirmButton: true
                });

              }

      			});

  				} else {
  						console.log('not valid');
  						swal("", "Falta llenar algunos campos", "error");
  				}

        });
        //End BtnGuardar

        //BtnOpc
        $(document.body).on('click', '.BtnOpc' ,function(){

          var table = $("#TableIn");

          clave       = $(this).data('clave');
          id          = $(this).data('id');
          nombre      = $(this).data('nombre');
          precio      = $(this).data('precio');
          precio      = parseFloat(precio);
          comision    = $(this).data('comision');
          comision    = parseFloat(comision);
          comisiondep = $(this).data('comisiondep');
          comisiondep = parseFloat(comisiondep);
          claveA      = clave.replace(/ /g, '-');
          existencia  = $(this).data('existencia');
          existencia  = parseFloat(existencia);

          //console.log(existencia);
          //Actualiza Existencia
          Exi = existencia - 1;
          $(this).data('existencia', Exi);
          if( Exi <= 0 ){
            $(this).prop('disabled', true);
            swal({
              title: "¡Sin Stock!",
              text: "Cantidad máxima.",
              //timer: 2000,
              showConfirmButton: true
            });
          }
          //$(this).attr('data-existencia', Exi);

          //Busca si ya esta en la Lista
          Row = "Row"+claveA;
          //console.log(Row);
          if (document.getElementById(Row)) {
            //Si el fila ya existe

            InputCantidad     = $('#Row'+claveA).find('.RowCantidad');
            TdCantidad        = $('#Row'+claveA).find('.TdCantidad');
            InputPrecio       = $('#Row'+claveA).find('.RowPrecio');
            TdPrecio          = $('#Row'+claveA).find('.TdPrecio');
            InputSubtotal     = $('#Row'+claveA).find('.RowSubtotal');
            TdSubtotal        = $('#Row'+claveA).find('.TdSubtotal');
            InputComision     = $('#Row'+claveA).find('.RowComision');
            InputComisionDep  = $('#Row'+claveA).find('.RowComisionDep');
            TdComision        = $('#Row'+claveA).find('.TdComision');

            //Cantidad
              cantidad = parseFloat(InputCantidad.val());
              cantidad = cantidad + 1;
              InputCantidad.val(cantidad);
              TdCantidad.html(cantidad);
            //End Cantidad

            //Subtotal
              subtotalA = parseFloat(InputSubtotal.val());
              subtotalB = subtotalA + precio;
              subtotalB = subtotalB.toFixed(2);
              InputSubtotal.val(subtotalB);
              TdSubtotal.html(subtotalB);
            //End Subtotal

            //Comision
              if( comisiondep > 0 ){ comision = comision - comisiondep; }
              // console.log('Com: '+comision);
              comisionA = parseFloat(InputComision.val());
              comisionB = parseFloat(comisionA) + parseFloat(comision);
              InputComision.val(comisionB);
              TdComision.html(comisionB);

              comisiondep = parseFloat(comisiondep);
              comisionDepA = parseFloat(InputComisionDep.val());
              comisionDepB = comisionDepA + comisiondep;
              InputComisionDep.val(comisionDepB);
            //End Comision

            //Suma el Total
            var sum = 0;
            $('.RowSubtotal').each(function() {
              sum += Number($(this).val());
            });
            console.log(sum);
            sum = sum.toFixed(2);

            $('#Deuda').val(sum);
            $('#Total').val(sum);
            $('#TotalTab').html(sum);
            //End Suma el Total

          }else{
            //Si la fila no existe

            ConArt    = ConArt + 1;
            cantidad  = 1;
            subtotal  = precio;
            subtotal = subtotal.toFixed(2);

            //Suma el Total
            var sum = 0;
            $('.RowSubtotal').each(function() {
              sum += Number($(this).val());
            });
            console.log(sum);
            sum = sum.toFixed(2);
            $('#Deuda').val(sum);
            $('#Total').val(sum);
            $('#TotalTab').html(sum);
            //End Suma el Total

            Lineas = Lineas + 1;
            if( Lineas >= 1 ){
              $('#BtnContinuar').show();
            }
          }

          if (document.getElementById(Row)) {

          }else{

            if( comisiondep > 0 ){ comision = comision - comisiondep; }

            $('#FormPer').parsley().destroy();

            precio = precio.toFixed(2);

            RowAdd = "\
              <tr class='Line' id='Row"+claveA+"'>\
                <td>\
                  <input type='hidden' name='Arts[]' value='"+ConArt+"' />\
                  <input type='hidden' class='RowClave' name='Art["+ConArt+"][Id]' value='"+id+"' />\
                  <input type='hidden' class='RowClave' name='Art["+ConArt+"][Clave]' value='"+clave+"' />\
                  <input type='hidden' class='RowClave' name='Art["+ConArt+"][Nombre]' value='"+nombre+"' />\
                  <input data-min='1' type='hidden' class='RowCantidad' name='Art["+ConArt+"][Cantidad]' value='"+cantidad+"' />\
                  <input type='hidden' class='RowPrecio' name='Art["+ConArt+"][Precio]' value='"+precio+"' />\
                  <input type='hidden' class='RowSubtotal' name='Art["+ConArt+"][Subtotal]' value='"+subtotal+"' />\
                  <input type='hidden' class='RowComision' name='Art["+ConArt+"][Comision]' value='"+comision+"' />\
                  <input type='hidden' class='RowComisionDep' name='Art["+ConArt+"][ComisionDep]' value='"+comisiondep+"' />\
                  "+nombre+"\
                </td>\
                <td class='TdCantidad'>"+cantidad+"</td>\
                <td class='TdPrecio'>"+precio+"</td>\
                <td class='TdSubtotal'>"+subtotal+"</td>\
                <td><button data-clave='"+clave+"' type='button' class='btn btn-sm btn-danger DelLine'><i class='fa fa-times'></i></button></td>\
              </tr>\
            ";
            table.append(RowAdd);

            $('#FormPer').parsley();

            //Suma el Total
            var sum = 0;
            $('.RowSubtotal').each(function() {
              sum += Number($(this).val());
            });
            console.log(sum);
            sum = sum.toFixed(2);
            $('#Deuda').val(sum);
            $('#Total').val(sum);
            $('#TotalTab').html(sum);
            //End Suma el Total

          }

        });
        //End BtnOpc

        //Del Line
        $(document.body).on('click', '.DelLine' ,function(){

          var Cla = $(this).data('clave');
          var Cant = $(this).parents('.Line').find('.RowCantidad').val();
          //console.log(Cla+' - '+Cant);
          //console.log('[data-clav="'+Cla+'"]');
          btn = $('[data-clav="'+Cla+'"]');
          var can = btn.data('existencia');
          //console.log('Can...: '+can);
          var Cati = parseInt(Cant) + parseInt(can);
          //console.log('Cantidad: '+Cati);
          $('[data-clav="'+Cla+'"]').data('existencia', Cati);
          $('[data-clav="'+Cla+'"]').prop('disabled', false);

          Lineas = Lineas - 1;
          if( Lineas < 1 ){
            $('#BtnContinuar').hide();
          }
          $(this).parents('.Line').remove();

          //Suma el Total
          var sum = 0;
          $('.RowSubtotal').each(function() {
            sum += Number($(this).val());
          });
          console.log(sum);
          sum = sum.toFixed(2);
          $('#Deuda').val(sum);
          $('#Total').val(sum);
          $('#TotalTab').html(sum);
          //End Suma el Total

        });
        //End Del Line

        //Btn Continuar
        $(document.body).on('click', '#BtnContinuar' ,function(){
          $('#FormPer').parsley().destroy();
          action = 'show';
          $.post("clientes.php", { action: action }, function(data){
            $('#Cliente').html(data);
            $(".chosen-select").chosen();
            $('.chosen-select').trigger("chosen:updated");
            $('#FormPer').parsley();
            $('#Modal-Pago').modal('show');
          });
        });
        //End Btn Continuar

        //Btn-AddMetodoPago
        var PagNum = 0;
        $(document.body).on('click', '.Btn-AddMetodoPago' ,function(){
          console.log('test');
          action = 'show';
          PagNum = PagNum + 1;
          $.post("metodo-pago.php", { action: action, PagNum: PagNum }, function(data){
            $('.MetodosPagos').append(data);
            $(".chosen-select").chosen();
            $('.chosen-select').trigger("chosen:updated");
            $('#FormPer').parsley();
          });
        });
        //End Btn-AddMetodoPago

        //Del CardPago
        $(document.body).on('click', '.Btn-DelCardPago' ,function(){
          $(this).parents('.CardPago').remove();
          var sum = 0;
          $('.PagoIn').each(function() {
            sum += Number($(this).val());
          });
          sumA = sum.toFixed(2);
          $('.PagoFull').val(sumA);

          total = Number($('#Total').val());
          restante = total - sum;
          restante = restante.toFixed(2);
          $('#Deuda').val(restante);
        });
        //End Del CardPago

        //Cambia Pago
        $(document.body).on('change keyup', '.PagoIn' ,function(){
          var sum = 0;
          $('.PagoIn').each(function() {
            sum += Number($(this).val());
          });
          sumA = sum.toFixed(2);
          $('.PagoFull').val(sumA);
          total = Number($('#Total').val());
          restante = total - sum;
          restante = restante.toFixed(2);
          $('#Deuda').val(restante);

          //Valida Deuda no sea negativa
          if(restante > -0.001) {
            $('.BtnGuardar').show();
            $('.CardErrorA').hide();
          }else{
            $('.BtnGuardar').hide();
            $('.CardErrorA').show();
          }

        });

        //Cambia PagoEfectivo
        $(document.body).on('change keyup', '#Modal-PagoEfectivo' ,function(){
          efectivo        = Number($(this).val());
          tarjeta         = Number($('#Modal-PagoTarjeta').val());
          transferencia   = Number($('#Modal-PagoTransferencia').val());
          pagado          = efectivo + tarjeta + transferencia;

          var sum = 0;
          $('.RowSubtotal').each(function() {
            sum += Number($(this).val());
          });

          deuda = sum;
          restante = deuda - pagado;
          restante = restante.toFixed(2);
          $('#Deuda').val(restante);

        });
        //End Cambia PagoEfectivo

        //Cambia PagoTarjeta
        $(document.body).on('change keyup', '#Modal-PagoTarjeta' ,function(){
          tarjeta         = Number($(this).val());
          efectivo        = Number($('#Modal-PagoEfectivo').val());
          transferencia   = Number($('#Modal-PagoTransferencia').val());
          pagado          = efectivo + tarjeta + transferencia;

          var sum = 0;
          $('.RowSubtotal').each(function() {
            sum += Number($(this).val());
          });

          deuda = sum;
          restante = deuda - pagado;
          restante = restante.toFixed(2);
          $('#Deuda').val(restante);

        });
        //End Cambia PagoTarjeta

        //Cambia PagoTransferencia
        $(document.body).on('change keyup', '#Modal-PagoTransferencia' ,function(){
          transferencia   = Number($(this).val());
          efectivo        = Number($('#Modal-PagoEfectivo').val());
          tarjeta         = Number($('#Modal-PagoTarjeta').val());
          pagado          = efectivo + tarjeta + transferencia;

          var sum = 0;
          $('.RowSubtotal').each(function() {
            sum += Number($(this).val());
          });

          deuda = sum;
          restante = deuda - pagado;
          restante = restante.toFixed(2);
          $('#Deuda').val(restante);

        });
        //End Cambia PagoTransferencia

        //Seleccion de metodo de pago
        $(document.body).on('change', '.SelMetodo' ,function(){
          val = $(this).val();
          sel = $(this).parents('.CardPago');
          if( val == 6 ){

            sel.find('.Btn-DelCardPago').hide();

            $('.Btn-AddMetodoPago').hide();

            $('.CardPago').addClass('RomoveItem');
            sel.removeClass('RomoveItem');
            $('.RomoveItem').remove();

            var sum = 0;
            $('.PagoIn').each(function() {
              sum += Number($(this).val());
            });
            sumA = sum.toFixed(2);
            $('.PagoFull').val(sumA);
            total = Number($('#Total').val());
            restante = total - sum;
            restante = restante.toFixed(2);
            $('#Deuda').val(restante);

            //Valida Deuda no sea negativa
            if(restante > -0.001) {
              $('.BtnGuardar').show();
              $('.CardErrorA').hide();
            }else{
              $('.BtnGuardar').hide();
              $('.CardErrorA').show();
            }

          }else{
            $('.Btn-AddMetodoPago').show();
            sel.find('.Btn-DelCardPago').show();
          }
        });
        //End Seleccion de metodo de pago

        <?php if( $Saved == 'Ok' ){ ?>
          swal({
            title: "¡Guardado!",
            text: "Venta guardada correctamente.\nFolio: <?php echo $DocFolio; ?>",
            //timer: 2000,
            showConfirmButton: true
          });
        <?php } ?>

      });

    </script>

</body>
</html>
