<?php
  $Position = '../../../';
  require_once($Position.'config/config.php');
  require_once($Position.'config/conexion.php');
  require_once($Position.'config/user.php');
  require_once($Position.'funciones/acces.php');
  require_once($Position.'funciones/logout.php');
  require_once($Position.'funciones/funciones.php');
  require_once($Position.'php/phpqrcode/qrlib.php');

  if( $Id ){

    $Id = $Id;

    //Factura
    $Query = "
      SELECT
        fac.Id,
        fac.Sandbox,
        fac.Fecha, fac.RfcEmisor, fac.Emisor,
        fac.CodigoPostal, RegimenFiscal,
        fac.RfcReceptor, fac.Receptor,
        fac.Subtotal, fac.Impuesto, fac.Total,
        fac.Serie, fac.Folio, fac.IdFac, fac.Uuid,
        fac.CertNumber, fac.CfdiSign, fac.SatCert,
        fac.SatSign, fac.CadenaOriginal,
        fac.Xml, fac.Pdf,
        fac.Cancelada, fac.FechaCancelacion,
        fac.Fk_MetodoPago, fac.Fk_FormaPago,
        fac.Fk_RelacionTipo, fac.CfdisRelacionados,
        tip.Clave AS TipoClave, tip.Tipo,
        uso.Clave AS UsoClave, uso.Uso,
        fac.Moneda, fac.Observaciones,
        mon.Nombre AS MonedaNombre
      FROM Facturas fac
      LEFT JOIN FacturasTipos tip ON tip.Id = fac.Fk_Tipo
      LEFT JOIN FacturasUsos uso ON uso.Id = fac.Fk_Uso
      LEFT JOIN Monedas mon ON mon.Clave = fac.Moneda
      WHERE fac.Id = '$Id'
        AND fac.Fk_Cuenta = '$Cuenta[Id]'
    ";
    $Result = mysqli_query($mysqli, $Query);
    $Fac = mysqli_fetch_assoc($Result);
    if( $Fac[Id] ){
?>
  <!DOCTYPE html>
  <html lang="en">
    <link href="<?php echo $Position; ?>facturacion/facturas/pdf/style-pdf.css" rel="stylesheet" />
    <body>

      <!-- Header -->
      <header>

        <table class="Table">
          <tr>
            <td
              class="col-sm-6"
              style="padding-top:4px;"
            >
              <strong>Folio:</strong> <?php echo $Fac[Serie].$Fac[Folio]; ?>
            </td>
            </td>
            <td class="col-sm-6 text-right">
              <div>
                <span
                  class="pagenum"
                  style="
                    position:absolute;
                    right:-200px;
                    top:4px;
                  "
                > de DOMPDF_PAGE_COUNT_PLACEHOLDER</span>
              </div>
            </td>
          </tr>
        </table>

      </header>
      <!-- Header -->

      <!-- Footer -->
      <footer>
        <table class="Table m-t-10">
          <tr>
            <td class="col-sm-12 text-center">
              Este documento es una representación impresa de un CFDI
            </td>
          </tr>
        </table>
      </footer>
      <!-- Footer -->

      <!-- Main -->
      <main>
        <page>

          <table class="Table TableIn">
            <tr>

              <!-- Logo -->
              <td style="width:162px;">
                <img
                  src="<?php echo $Position; ?>documentos/logos/<?php  if( $PerfilSel[UsarLogo] == 1 ){ echo $PerfilSel[Id]; }else{ echo "0"; } ?>.jpg"
                  style="width:160px;"
                />
              </td>
              <!-- End Logo -->

              <!-- Separación -->
              <td style="width:20px;">
              </td>
              <!-- End Separación -->

              <td>

                <!-- Emisor-Receptor -->
                <table>
                  <tr>

                    <!-- Emisor -->
                    <td style="width:260px;">
                      <div class="m-b-5">
                        <strong>Emisor:</strong>
                      </div>
                      <div class="m-b-10">
                        <?php echo $Fac[Emisor]; ?><br>
                        <?php echo $Fac[RfcEmisor]; ?>
                      </div>
                      <div>
                        <strong>Lugar de Expedición:</strong> <?php echo $Fac[CodigoPostal]; ?><br>
                        <strong>Régimen Fiscal:</strong> <?php echo $Fac[RegimenFiscal]; ?>
                      </div>
                    </td>
                    <!-- End Emisor -->

                    <!-- Separación -->
                    <td style="width:20px;">
                    </td>
                    <!-- End Separación -->

                    <!-- Receptor -->
                    <td style="">
                      <div class="m-b-5">
                        <strong>Receptor:</strong>
                      </div>
                      <div class="m-b-10">
                        <?php echo $Fac[Receptor]; ?><br>
                        <?php echo $Fac[RfcReceptor]; ?>
                      </div>
                      <div>
                        <strong>Uso del CFDI:</strong> <?php echo $Fac[UsoClave].' - '.$Fac[Uso]; ?>
                      </div>
                    </td>
                    <!-- End Receptor -->

                  </tr>
                </table>
                <!-- End Emisor-Receptor -->

                <table>

                  <!-- Folio Fiscal -->
                  <tr>
                    <td>
                      <strong>Efecto del comprobante: </strong>
                    </td>
                    <td></td>
                    <td>
                      <?php echo $Fac[TipoClave].' - '.$Fac[Tipo]; ?>
                    </td>
                  </tr>
                  <!-- End Folio Fiscal -->

                  <!-- Folio Fiscal -->
                  <tr>
                    <td>
                      <strong>Folio Fiscal: </strong>
                    </td>
                    <td></td>
                    <td>
                      <?php echo $Fac[Uuid]; ?>
                    </td>
                  </tr>
                  <!-- End Folio Fiscal -->

                  <?php if( $Fac[Fk_RelacionTipo] ){ ?>
                    <!-- Uuids Relacionados -->
                    <tr>
                      <td>
                        <strong>Relación: </strong>
                      </td>
                      <td></td>
                      <td>
                        <?php
                          //Relacion
                          $Query = "
                            SELECT
                              re.Id, re.Clave, re.Nombre
                            FROM FacturasRelacionesTipos re
                            WHERE re.Id = '$Fac[Fk_RelacionTipo]'
                          ";
                          $Result = mysqli_query($mysqli, $Query);
                          $Rel = mysqli_fetch_assoc($Result);
                          echo $Rel[Clave].' - '.$Rel[Nombre];
                        ?>
                      </td>
                    </tr>
                    <?php if( $Fac[CfdisRelacionados] ){ ?>
                      <tr>
                        <td>
                          <strong>Uuids Relacionados: </strong>
                        </td>
                        <td></td>
                        <td>
                          <?php
                            $UuidRels = explode(",",$Fac[CfdisRelacionados]);
                            foreach ($UuidRels AS $UuidRel) {
                          ?>
                            <?php echo $UuidRel.'<br>'; ?>
                          <?php } ?>
                        </td>
                      </tr>
                    <?php } ?>
                    <!-- end Uuids Relacionados -->
                  <?php } ?>

                  <!-- Fecha -->
                  <tr>
                    <td>
                      <strong>Fecha / Hora de Emisión: </strong>
                    </td>
                    <td></td>
                    <td>
                      <?php
                        //echo CambioFechaInversa(date('Y-m-d', strtotime($Fac['Fecha'])));
                        echo date('Y/m/d', strtotime($Fac['Fecha']));
                      ?>
                      <?php echo date('H:i:s', strtotime($Fac['Fecha'])); ?>
                    </td>
                  </tr>
                  <!-- End Fech -->

                  <!-- CertNumber -->
                  <tr>
                    <td>
                      <strong>No. de Certificado Digital: </strong>
                    </td>
                    <td></td>
                    <td>
                      <?php echo $Fac[CertNumber]; ?>
                    </td>
                  </tr>
                  <!-- End CertNumber -->

                  <?php if( $Fac[Observaciones] ){ ?>
                    <!-- Observaciones -->
                    <tr>
                      <td>
                        <strong>Observaciones: </strong>
                      </td>
                      <td></td>
                      <td>
                        <?php echo $Fac[Observaciones]; ?>
                      </td>
                    </tr>
                    <!-- End Observaciones -->
                  <?php } ?>

                </table>

              </td>

            </tr>
          </table>

          <!-- Sep Line -->
          <div class="m-b-20 m-t-20">
            <hr>
          </div>
          <!-- End Sep Line -->

          <!-- Conceptos -->

            <!-- Tabla Conceptos -->
            <div style="page-break-inside: avoid;">
              <table class="Table TableA">
                <thead>
                  <tr>
                    <th style="width:auto;">Concepto</th>
                    <th style="width:120px;">Clave</th>
                    <th style="width:80px;">Unidad</th>
                    <th style="width:100px;text-align:right;">Precio</th>
                    <th style="width:100px;text-align:right;">Cant.</th>
                    <th style="width:100px;text-align:right;">Total</th>
                  </tr>
                </thead>
              </table>
            </div>

            <?php
              //Conceptos
              $Query = "
                SELECT
                  con.Id, con.Descripcion, con.Clave, con.Unidad,
                  con.Precio, con.Cantidad, con.Subtotal, con.Descuento,
                  con.Iva, con.DescuentoTipo, con.Total
                FROM FacturasConceptos con
                WHERE con.Fk_Factura = '$Fac[Id]'
                ORDER BY con.Id ASC
              ";
              $Conceptos = $mysqli->query($Query);
              mysqli_data_seek($Conceptos, 0);
              while($Con = mysqli_fetch_array($Conceptos)) {
            ?>
              <div class="" style="page-break-inside: avoid;">
                <table class="Table TableA">
                  <tbody class="Productos">
                    <tr>

                      <!-- Descripcion -->
                      <td style="width:auto;text-align:left;"><?php echo $Con[Descripcion]; ?></td>
                      <!-- End Descripcion -->

                      <!-- Clave -->
                      <td style="width:120px;text-align:left;"><?php echo $Con[Clave] ?></td>
                      <!-- End Clave -->

                      <!-- Unidad -->
                      <td style="width:80px;text-align:left;"><?php echo $Con[Unidad] ?></td>
                      <!-- End Unidad -->

                      <!-- Precio -->
                      <td style="width:100px;text-align:right;"><?php echo number_format($Con[Precio],2,'.',','); ?></td>
                      <!-- End Precio -->

                      <!-- Cantidad -->
                      <td style="width:100px;text-align:right;"><?php echo $Con[Cantidad]; ?></td>
                      <!-- End Cantidad -->

                      <!-- Total -->
                      <td style="width:100px;text-align:right;"><?php
                        $ConTotal = $Con[Cantidad] * $Con[Precio];
                        echo number_format($ConTotal,2,'.',',');
                        $SubTotal = $SubTotal + $ConTotal;
                        $TotalImpuesto = $TotalImpuesto + $Con[Iva];
                      ?></td>
                      <!-- End Total -->

                    </tr>
                  </tbody>
                </table>
              </div>
            <?php } ?>

            <div class="m-b-40" style="page-break-inside: avoid;">
              <table class="Table TableA TableConceptsSizes">

                <!-- Tabla Footer -->
                <tfoot>

                  <!-- Subtotal -->
                  <tr>
                    <th style="width:220px;"></th>
                    <th></th>
                    <th></th>
                    <th></th>
                    <th>
                      <div class="text-right" style="font-weight:bold;">
                        Subtotal:
                      </div>
                    </th>
                    <th>
                      <div class="text-right">
                        <?php echo number_format($SubTotal,2,'.',','); ?>
                      </div>
                    </th>
                  </tr>
                  <!-- End Subtotal -->

                  <!-- Impuestos -->
                  <tr>
                    <th></th>
                    <th></th>
                    <th></th>
                    <th></th>
                    <th>
                      <div class="text-right" style="font-weight:bold;">
                        Impuestos:
                      </div>
                    </th>
                    <th>
                      <div class="text-right">
                        <?php echo number_format($TotalImpuesto,2,'.',','); ?>
                      </div>
                    </th>
                  </tr>
                  <!-- End Impuestos -->

                  <!-- Total Fila -->
                  <tr>

                    <!-- Total con letra y Moneda -->
                    <th colspan="4">

                      <table class="Table TableB">
                        <tr>
                          <td>
                            <div class="text-left">
                              <strong>Total con letra:</strong>
                            </div>
                          </td>
                          <td>
                            <div class="text-left">
                              <?php
                        				$Total = $SubTotal + $TotalImpuesto;

                        				$whole = floor($Total);      // 1
                        				$fraction = $Total - $whole; // .25

                        				$letras = NumeroALetras::convertir($whole, 'pesos');
                        				echo str_replace(" ","&nbsp;",$letras);
                        				echo "&nbsp;";
                        				if( $fraction == 0 ){ $fraction = '00';}
                        				$fraction  = number_format($fraction,2,'.',',');
                        				$fraction = ltrim($fraction,'0.');
                        				if( $fraction ){
                                  echo $fraction;
                                }else{
                                  echo "00";
                                }
                        				echo '/100';
                      				?>
                              M.N.
                            </div>
                          </td>
                        </tr>
                        <tr>
                          <td>
                            <div class="text-left">
                              <strong>Moneda:</strong>
                            </div>
                          </td>
                          <td>
                            <div class="text-left">
                              <?php echo $Fac[Moneda].' - '.$Fac[MonedaNombre]; ?>
                            </div>
                          </td>
                        </tr>
                      </table>

                    </th>
                    <!-- End Total con letra -->

                    <!-- Total -->
                    <th>
                      <div class="text-right" style="font-weight:bold;">
                        Total:
                      </div>
                    </th>
                    <!-- end Total -->

                    <!-- Total -->
                    <th>
                      <div class="text-right" style="font-weight:bold;">
                        <?php
                          echo number_format($Total,2,'.',',');
                        ?>
                      </div>
                    </th>
                    <!-- End Total -->

                  </tr>
                  <!-- End Total Fila -->

                </tfoot>
                <!-- End Tabla Footer -->

              </table>
            </div>
            <!-- End Tabla Conceptos -->

          <!-- End Conceptos -->

          <!-- Datos -->
          <div class="m-b-10" style="page-break-inside: avoid;">

            <!-- Tabla Datos -->
            <table class="Table TableA">

              <tr>
                <td>
                  <div class="text-left">
                    <strong>Forma de Pago:</strong>
                  </div>
                </td>
                <td>
                  <div class="text-left">
                    <strong>Método de Pago:</strong>
                  </div>
                </td>
                <td>
                  <div class="text-left">
                    <strong>Banco:</strong>
                  </div>
                </td>
                <td>
                  <div class="text-left">
                    <strong>Cuenta:</strong>
                  </div>
                </td>
                <td>
                  <div class="text-left">
                    <strong>Condiciones de Pago:</strong>
                  </div>
                </td>
              </tr>

              <tr>

                <!-- Forma de Pago -->
                <td>
                  <div class="text-left">
                    <?php
                      //Formas
                      $Query = "
                        SELECT
                          fo.Id, fo.Clave, fo.Forma
                        FROM FacturasFormasPagos fo
                        WHERE fo.Clave = '$Fac[Fk_FormaPago]'
                      ";
                      $Result = mysqli_query($mysqli, $Query);
                      $Forma = mysqli_fetch_assoc($Result);
                      echo $Forma[Clave].' - '.$Forma[Forma];
                    ?>
                  </div>
                </td>
                <!-- End Forma de Pago -->

                <!-- Método de Pago -->
                <td>
                  <div class="text-left">
                    <?php
                      //Metodo
                      $Query = "
                        SELECT
                          met.Id, met.Clave, met.Metodo
                        FROM FacturasMetodosPagos met
                        WHERE met.Clave = '$Fac[Fk_MetodoPago]'
                      ";
                      $Result = mysqli_query($mysqli, $Query);
                      $Metodo = mysqli_fetch_assoc($Result);
                      echo $Metodo[Clave].' - '.$Metodo[Metodo];
                    ?>
                  </div>
                </td>
                <!-- End Método de Pago -->

                <!-- Banco -->
                <td>
                  <div class="text-left">
                    <?php echo $Fac[Banco]; ?>
                  </div>
                </td>
                <!-- End Banco -->

                <!-- Cuenta -->
                <td>
                  <div class="text-left">
                    <?php echo $Fac[Cuenta]; ?>
                  </div>
                </td>
                <!-- End Cuenta -->

                <!-- Condiciones de Pago -->
                <td>
                  <div class="text-left">
                    <?php echo $Fac[Condiciones]; ?>
                  </div>
                </td>
                <!-- End Condiciones de Pago -->

              </tr>
            </table>
            <!-- End Tabla Datos -->

          </div>
          <!-- End Datos -->

          <!-- Cadenas y Qr -->
          <div style="page-break-inside: avoid;">
            <table class="Table TableA">
              <tr>

                <!-- Qr -->
                <td style="width:160px;">
                  <?php
                    //set it to writable location, a place for temp generated PNG files
                    $PNG_TEMP_DIR = dirname(__FILE__).DIRECTORY_SEPARATOR.'temp'.DIRECTORY_SEPARATOR;

                    //html PNG location prefix
                    $PNG_WEB_DIR = 'temp/';
                    $PNG_WEB_DIR = $Position.'facturacion/facturas/pdf/temp/';

                    //ofcourse we need rights to create temp dir
                    if (!file_exists($PNG_TEMP_DIR))
                        mkdir($PNG_TEMP_DIR);

                    //$filename = $PNG_TEMP_DIR.$Fac[Id].'qr.png';
                    $filename = $Position.'facturacion/facturas/pdf/temp/'.$Fac[Id].'qr.png';

                    $matrixPointSize = 3;

                    //8 Last Chars Sello digital
                    $laststring = substr($Fac[CfdiSign], -8);

                    //default data
                    $SatUrl = 'https://verificacfdi.facturaelectronica.sat.gob.mx/default.aspx?id='.$Fac[Uuid].'&re='.$Fac[RfcEmisor].'&rr='.$Fac[RfcReceptor].'&tt='.$Fac[Total].'&fe='.$laststring;
                    QRcode::png($SatUrl, $filename, $errorCorrectionLevel, $matrixPointSize, 2);

                    //display generated file
                    echo '<img style="width:160px;" src="'.$PNG_WEB_DIR.basename($filename).'" />';

                  ?>

                </td>
                <!-- End Qr -->

                <!-- Separación -->
                <td style="width:20px;">
                </td>
                <!-- End Separación -->

                <!-- Cadenas -->
                <td>

                  <!-- Cadena Original -->
                  <div class="text-left m-b-10">
                    <div class="m-b-10">
                      <strong>Cadena Original del complemento de Certifiación Digital del SAT</strong><br>
                    </div>
                    <div class="Font-Size-10">
                      <?php
                        $CadenaOriginal = "||1.1|".$Fac[Uuid]."|".date('Y-m-d', strtotime($Fac['Fecha']))."T".date('H:i:s', strtotime($Fac['Fecha']))."|".$PlataformaFac[Rfc]."|".$Fac[CfdiSign].'|'.$Fac[SatCert].'||';
                        $CadenaOriginal = str_split($CadenaOriginal,100);
                        foreach ($CadenaOriginal AS $Text) {
                          echo $Text.'<br>';
                        }
                      ?>
                    </div>
                  </div>
                  <!-- End Cadena Original -->

                  <!-- Cadena Original -->
                  <div class="text-left m-b-10">
                    <div class="m-b-10">
                      <strong>Sello Digital del CFDI</strong>
                    </div>
                    <div class="Font-Size-10">
                      <?php
                        $CfdiSign = str_split($Fac[CfdiSign],100);
                        foreach ($CfdiSign AS $Text) {
                          echo $Text.'<br>';
                        }
                      ?>
                    </div>
                  </div>
                  <!-- End Cadena Original -->

                  <!-- Cadena Original -->
                  <div class="text-left">
                    <div class="m-b-10">
                      <strong>Sello Digital del SAT</strong>
                    </div>
                    <div class="Font-Size-10">
                      <?php
                        $SatSign = str_split($Fac[SatSign],100);
                        foreach ($SatSign AS $Text) {
                          echo $Text.'<br>';
                        }
                      ?>
                    </div>
                  </div>
                  <!-- End Cadena Original -->

                </td>
                <!-- End Cadenas -->

              </tr>
            </table>
          </div>
          <!-- End Cadenas y Qr -->

        </page>
      </main>
      <!-- End Main -->

    </body>
  </html>
<?php }} ?>
