<?php

//Edad
function edad($fecha){
  $date = new DateTime($fecha);
  $now = new DateTime();
  $interval = $now->diff($date);
  return $interval->y;
}

function corta_texto($texto, $num) {
 $txt = (strlen($texto) > $num) ? substr($texto,0,$num)."..." : $texto;
 return $txt;
}

function word_limiter($string, $word_limit) {
    $words = explode(" ",$string);
    return implode(" ",array_splice($words,0,$word_limit));
  }

//Quitar Espacios
function limpia_espacios($cadena){
    $cadena = str_replace(' ', '', $cadena);
    return $cadena;
}

//Quitar Acentos
function limpia_acentos($cadena){
    $originales = 'ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖØÙÚÛÜÝÞ
ßàáâãäåæçèéêëìíîïðñòóôõöøùúûýýþÿŔŕ';
    $modificadas = 'aaaaaaaceeeeiiiidnoooooouuuuy
bsaaaaaaaceeeeiiiidnoooooouuuyybyRr';
    $cadena = utf8_decode($cadena);
    $cadena = strtr($cadena, utf8_decode($originales), $modificadas);
    $cadena = strtolower($cadena);
    return utf8_encode($cadena);
}

//Filtro SQL
function filtro($cadena){
/*
	Filtra los datos para evitar Inyecciones Sql
*/
	return addslashes(mysql_real_escape_string(trim($cadena)));
}

//Meses
$months = array(1 => "Enero",
                2 => "Febrero",
                3 => "Marzo",
                4 => "Abril",
                5 => "Mayo",
                6 => "Junio",
                7 => "Julio",
                8 => "Agosto",
                9 => "Septiembre",
                10=> "Octubre",
                11=> "Noviembre",
                12=> "Diciembre");

$monthsshort = array(1 => "Ene",
                2 => "Feb",
                3 => "Mar",
                4 => "Abr",
                5 => "May",
                6 => "Jun",
                7 => "Jul",
                8 => "Ago",
                9 => "Sep",
                10=> "Oct",
                11=> "Nov",
                12=> "Dic");

$MonthText = array(	'Ene' => '01',
                	'Feb' => '02',
               		'Mar' => '03',
              		'Abr' => '04',
              	 	'May' => '05',
                	'Jun' => '06',
               		'Jul' => '07',
               	 	'Ago' => '08',
            	    'Sep' => '09',
               	 	'Oct' => '10',
               	 	'Nov' => '11',
              	  	'Dic' => '12');

//Cambio de Formato de Fecha
function CambioFecha($Fecha)
{
	$MonthText = array(	'Ene' => '01',
                	'Feb' => '02',
               		'Mar' => '03',
              		'Abr' => '04',
              	 	'May' => '05',
                	'Jun' => '06',
               		'Jul' => '07',
               	 	'Ago' => '08',
            	    'Sep' => '09',
               	 	'Oct' => '10',
               	 	'Nov' => '11',
              	  	'Dic' => '12');
    $Dia	 	= substr($Fecha, 0, -14);
	$MesText 	= substr($Fecha, 5, -8);
	$Ano 		= substr($Fecha, 12);
	$Mes 		= $MonthText[$MesText];
	$Fecha 		= $Ano.'-'.$Mes.'-'.$Dia;
	return $Fecha;
}

//Cambio de Formato de Fecha Completa
function CambioFechaCompleta($Fecha)
{
	$MonthText = array(	'Enero' => '01',
                	'Febrero' => '02',
               		'Marzo' => '03',
              		'Abril' => '04',
              	 	'Mayo' => '05',
                	'Junio' => '06',
               		'Julio' => '07',
               	 	'Agosto' => '08',
            	    'Septiembre' => '09',
               	 	'Octubre' => '10',
               	 	'Noviembre' => '11',
              	  'Diciembre' => '12');
  $FechaChange = explode(" / ", $Fecha);
  $Dia	 	  = $FechaChange[0];
	$MesText  = $FechaChange[1];
	$Ano 		  = $FechaChange[2];
	$Mes 		  = $MonthText[$MesText];
	$Fecha 		= $Ano.'-'.$Mes.'-'.$Dia;
	return $Fecha;
}

//Cambio de Formato de Fecha Completa Inversa
function CambioFechaInversa($Fecha)
{
	$MonthText = array(	'01' => 'Enero',
                	'02' => 'Febrero',
               		'03' => 'Marzo',
              		'04' => 'Abril',
              	 	'05' => 'Mayo',
                	'06' => 'Junio',
               		'07' => 'Julio',
               	 	'08' => 'Agosto',
            	    '09' => 'Septiembre',
               	 	'10' => 'Octubre',
               	 	'11' => 'Noviembre',
              	  '12' => 'Diciembre');
  $FechaChange = explode("-", $Fecha);
  $Dia	 	  = $FechaChange[2];
	$MesText  = $FechaChange[1];
	$Ano 		  = $FechaChange[0];
	$Mes 		  = $MonthText[$MesText];
	$Fecha 		= $Dia.' / '.$Mes.' / '.$Ano;
	return $Fecha;
}

//Tamño de Imagen
function getHeight($image) {
	$size = getimagesize($image);
	$height = $size[1];
	return $height;
}
function getWidth($image) {
	$size = getimagesize($image);
	$width = $size[0];
	return $width;
}

function ae_detect_ie()
{
    if (isset($_SERVER['HTTP_USER_AGENT']) &&
    (strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE') !== false))
        return true;
    else
        return false;
}

function randomKey($length) {
    $pool = array_merge(range(0,9), range('a', 'z'),range('A', 'Z'));

    for($i=0; $i < $length; $i++) {
        $key .= $pool[mt_rand(0, count($pool) - 1)];
    }
    return $key;
}

function getAge($date) {
    return intval(date('Y', time() - strtotime($date))) - 1970;
}

//Password Random
function randomPassword() {
    $alphabet = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890';
    $pass = array(); //remember to declare $pass as an array
    $alphaLength = strlen($alphabet) - 1; //put the length -1 in cache
    for ($i = 0; $i < 8; $i++) {
        $n = rand(0, $alphaLength);
        $pass[] = $alphabet[$n];
    }
    return implode($pass); //turn the array into a string
}

//Minutos entre dos fechas
function minutos_transcurridos($fecha_i,$fecha_f){
	$minutos = (strtotime($fecha_i)-strtotime($fecha_f))/60;
	$minutos = abs($minutos); $minutos = floor($minutos);
	return $minutos;
}

//Clase que implementa un coversor de números a letras
class NumeroALetras
{
    private static $UNIDADES = [
        '',
        'UN ',
        'DOS ',
        'TRES ',
        'CUATRO ',
        'CINCO ',
        'SEIS ',
        'SIETE ',
        'OCHO ',
        'NUEVE ',
        'DIEZ ',
        'ONCE ',
        'DOCE ',
        'TRECE ',
        'CATORCE ',
        'QUINCE ',
        'DIECISEIS ',
        'DIECISIETE ',
        'DIECIOCHO ',
        'DIECINUEVE ',
        'VEINTE '
    ];
    private static $DECENAS = [
        'VENTI',
        'TREINTA ',
        'CUARENTA ',
        'CINCUENTA ',
        'SESENTA ',
        'SETENTA ',
        'OCHENTA ',
        'NOVENTA ',
        'CIEN '
    ];
    private static $CENTENAS = [
        'CIENTO ',
        'DOSCIENTOS ',
        'TRESCIENTOS ',
        'CUATROCIENTOS ',
        'QUINIENTOS ',
        'SEISCIENTOS ',
        'SETECIENTOS ',
        'OCHOCIENTOS ',
        'NOVECIENTOS '
    ];
    public static function convertir($number, $moneda = '', $centimos = '', $forzarCentimos = false)
    {
        $converted = '';
        $decimales = '';
        if (($number < 0) || ($number > 999999999)) {
            return 'No es posible convertir el numero a letras';
        }
        $div_decimales = explode('.',$number);
        if(count($div_decimales) > 1){
            $number = $div_decimales[0];
            $decNumberStr = (string) $div_decimales[1];
            if(strlen($decNumberStr) == 2){
                $decNumberStrFill = str_pad($decNumberStr, 9, '0', STR_PAD_LEFT);
                $decCientos = substr($decNumberStrFill, 6);
                $decimales = self::convertGroup($decCientos);
            }
        }
        else if (count($div_decimales) == 1 && $forzarCentimos){
            $decimales = 'CERO ';
        }
        $numberStr = (string) $number;
        $numberStrFill = str_pad($numberStr, 9, '0', STR_PAD_LEFT);
        $millones = substr($numberStrFill, 0, 3);
        $miles = substr($numberStrFill, 3, 3);
        $cientos = substr($numberStrFill, 6);
        if (intval($millones) > 0) {
            if ($millones == '001') {
                $converted .= 'UN MILLON ';
            } else if (intval($millones) > 0) {
                $converted .= sprintf('%sMILLONES ', self::convertGroup($millones));
            }
        }
        if (intval($miles) > 0) {
            if ($miles == '001') {
                $converted .= 'MIL ';
            } else if (intval($miles) > 0) {
                $converted .= sprintf('%sMIL ', self::convertGroup($miles));
            }
        }
        if (intval($cientos) > 0) {
            if ($cientos == '001') {
                $converted .= 'UN ';
            } else if (intval($cientos) > 0) {
                $converted .= sprintf('%s ', self::convertGroup($cientos));
            }
        }
        if(empty($decimales)){
            $valor_convertido = $converted . strtoupper($moneda);
        } else {
            $valor_convertido = $converted . strtoupper($moneda) . ' CON ' . $decimales . ' ' . strtoupper($centimos);
        }
        return $valor_convertido;
    }
    private static function convertGroup($n)
    {
        $output = '';
        if ($n == '100') {
            $output = "CIEN ";
        } else if ($n[0] !== '0') {
            $output = self::$CENTENAS[$n[0] - 1];
        }
        $k = intval(substr($n,1));
        if ($k <= 20) {
            $output .= self::$UNIDADES[$k];
        } else {
            if(($k > 30) && ($n[2] !== '0')) {
                $output .= sprintf('%sY %s', self::$DECENAS[intval($n[1]) - 2], self::$UNIDADES[intval($n[2])]);
            } else {
                $output .= sprintf('%s%s', self::$DECENAS[intval($n[1]) - 2], self::$UNIDADES[intval($n[2])]);
            }
        }
        return $output;
    }
}

//Detect special conditions devices
$iPod    = stripos($_SERVER['HTTP_USER_AGENT'],"iPod");
$iPhone  = stripos($_SERVER['HTTP_USER_AGENT'],"iPhone");
$iPad    = stripos($_SERVER['HTTP_USER_AGENT'],"iPad");
$Android = stripos($_SERVER['HTTP_USER_AGENT'],"Android");
$webOS   = stripos($_SERVER['HTTP_USER_AGENT'],"webOS");

?>
