<?php
  $Seccion      = 'Reportes';
  $SubSeccion   = 'Ventas';
  $NameSec      = 'Reporte de Ventas';
  $UrlImgs      = 'images/cursos';
  $Position   = '../../';
  require_once($Position.'config/config.php');
  require_once($Position.'config/conexion.php');
  require_once($Position.'config/user.php');
  require_once($Position.'funciones/acces.php');
  require_once($Position.'funciones/logout.php');
  require_once($Position.'funciones/funciones.php');
  require_once($Position.'funciones/extras.php');

  $SecLine      = array($NameSec);

  //Buscador
  if( $_GET['Filtrar'] == 'Ok' ){

    $FechaDesde = CambioFechaCompleta($_GET['Desde']);
    $FechaHasta = CambioFechaCompleta($_GET['Hasta']);

  }else{
    $FechaDesde = date('Y-m-01');
    $FechaHasta = date('Y-m-t');
  }

  $Where = "
    WHERE
     (ven.Fecha BETWEEN '".$FechaDesde." 00:00:00' AND '".$FechaHasta." 23:59:59' )
  ";

  $FilDes = CambioFechaInversa($FechaDesde);
  $FilHas = CambioFechaInversa($FechaHasta);
  //End Buscador

  // Ventas
  $Query = "
    SELECT
      ven.Id,
      ven.Folio,
      ven.Documento,
      ven.Sucursal,
      ven.Fecha,
      ven.Total,
      ven.FechaCarga,
      emp.Nombre AS Empresa
    FROM KB_Ventas ven
    LEFT JOIN KB_Empresas emp ON emp.Id = ven.Fk_Empresa
      $Where
    ORDER BY ven.Fecha DESC
  ";
  $Ventas = $mysqli->query($Query);

?>

<!DOCTYPE html>
<html lang="en">

<?php require_once($Position.'head.php'); ?>

<body class="fix-sidebar fix-header card-no-border">
    <div class="preloader">
        <svg class="circular" viewBox="25 25 50 50">
            <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10" /> </svg>
    </div>
    <div id="main-wrapper">
      <?php require_once($Position.'header.php'); ?>
      <?php require_once($Position.'menu.php'); ?>
      <div class="page-wrapper">
        <div class="container-fluid">
          <div class="row page-titles">

            <?php require_once($Position.'title.php'); ?>

            <!-- Botones -->
            <div class="col-md-7 align-self-center text-right">
              <div class="btn-group" role="group" aria-label="Basic example">
                <?php if( $Perms[28] ){ ?>
                  <a href="item">
                    <button type="button" class="btn btn-sm btn-secondary">Nuevo<i class="fa fa-plus mar-l-10"></i></button>
                  </a>
                <?php } ?>
              </div>
            </div>
            <!-- End Botones -->

          </div>
          <div class="row">

            <!-- Buscador -->
            <div class="col-sm-12">
              <form method="get">
                <div class="card">
                  <div class="card-body">
                    <div class="row">

                      <!-- Desde -->
                      <div class="col-sm-4">
                        <div class="form-group">
                          <label class="control-label">Desde</label>
                          <input name="Desde" value="<?php echo $FilDes; ?>" type="text" class="form-control datepicker" placeholder="">
                        </div>
                      </div>
                      <!-- End Desde -->

                      <!-- Hasta -->
                      <div class="col-sm-4">
                        <div class="form-group">
                          <label class="control-label">Hasta</label>
                          <input name="Hasta" value="<?php echo $FilHas; ?>" type="text" class="form-control datepicker" placeholder="">
                        </div>
                      </div>
                      <!-- End Hasta -->

                      <!-- Filtrar -->
                      <div class="col-sm-4">
                        <div class="form-group">
                          <label class="control-label">.</label>

                          <!-- Btn Filtrar -->
                          <button class="btn btn-success btn-block" type="submit" name="button">
                            Filtrar <i class="fa fa-search mar-l-5"></i>
                          </button>
                          <!-- End Btn Filtrar -->

                          <input type="hidden" name="Filtrar" value="Ok" />
                        </div>
                      </div>
                      <!-- End Filtrar -->

                    </div>
                  </div>
                </div>
              </form>
            </div>
            <!-- Buscador -->

              <div class="col-12">
                <!-- Usuarios -->
                <div class="card">
                  <div class="card-body">
                    <div class="table-responsive m-t-20">
                      <table id="example23" class="display nowrap table table-hover table-striped table-bordered" cellspacing="0" width="100%">
                        <thead>
                          <tr>
                            <th>Folio</th>
                            <th>Fecha</th>
                            <th>Hora</th>
                            <th>Sucursal</th>
                            <th>Tipo</th>
                            <th>Empresa</th>
                            <th>Productos</th>
                            <th class="text-right">Total</th>
                          </tr>
                        </thead>
                        <tbody>
                            <?php
                              //Ventas
                              mysqli_data_seek($Ventas, 0);
                              while($Ven = mysqli_fetch_array($Ventas)) {
                            ?>
                              <tr>

                                <!-- Documento -->
                                <td class="text-left">
                                  <div>
                                    <?php echo $Ven['Documento']; ?>
                                  </div>
                                </td>
                                <!-- End Documento -->

                                <!-- Fecha -->
                                <td class="text-left">
                                  <div>
                                    <?php echo CambioFechaInversa(date('Y-m-d', strtotime($Ven['Fecha']))); ?>
                                  </div>
                                </td>
                                <!-- End Fecha -->

                                <!-- Hora -->
                                <td class="text-left">
                                  <div>
                                    <?php echo date('H:i', strtotime($Ven['Fecha'])); ?>
                                  </div>
                                </td>
                                <!-- End Hora -->

                                <!-- Sucursal -->
                                <td class="text-left">
                                  <div><?php
                                    echo $Ven['Sucursal'];
                                  ?></div>
                                </td>
                                <!-- End Sucursal -->

                                <!-- Tipo -->
                                <td class="text-left">
                                  <div><?php
                                    if( $Ven['FechaCarga'] ){
                                      echo 'Externa';
                                    }else{
                                      echo 'Interna';
                                    }
                                  ?></div>
                                </td>
                                <!-- End Tipo -->

                                <!-- Empresa -->
                                <td class="text-left">
                                  <div><?php echo $Ven['Empresa']; ?></div>
                                </td>
                                <!-- End Empresa -->

                                <!-- Tipo -->
                                <td class="text-left">
                                  <table
                                    style="width:100%;"
                                  >
                                    <thead>
                                      <tr>
                                        <td style="background: #f0f0f0;">
                                          Clave Pro.
                                        </td>
                                        <td style="width:100px;background: #f0f0f0;" class="text-right">
                                          Cantidad
                                        </td>
                                        <td style="width:100px;background: #f0f0f0;" class="text-right">
                                          Precio
                                        </td>
                                        <td style="width:100px;background: #f0f0f0;" class="text-right">
                                          Total
                                        </td>
                                      </tr>
                                    </thead>
                                    <tbody>
                                      <?php
                                        //Productos
                                        $Query = "
                                          SELECT
                                            pro.Id,
                                            pro.ProductoClave,
                                            pro.Cantidad,
                                            pro.Precio,
                                            pro.Descuento,
                                            pro.Total
                                          FROM KB_VentasProductos pro
                                            WHERE pro.Fk_Venta = '$Ven[Id]'
                                          ORDER BY pro.Id DESC
                                        ";
                                        $Items = $mysqli->query($Query);
                                        mysqli_data_seek($Items, 0);
                                        while($Item = mysqli_fetch_array($Items)) {
                                      ?>
                                        <tr>
                                          <td>
                                            <?php echo $Item[ProductoClave]; ?>
                                          </td>
                                          <td style="width:100px;" class="text-right">
                                            <?php echo $Item[Cantidad]; ?>
                                          </td>
                                          <td style="width:100px;" class="text-right">
                                            <?php echo $Item[Precio]; ?>
                                          </td>
                                          <td style="width:100px;" class="text-right">
                                            <div><?php echo number_format($Item['Total'],2,'.',','); ?></div>
                                          </td>
                                        </tr>
                                      <?php } ?>
                                    </tbody>
                                  </table>
                                </td>
                                <!-- End Tipo -->

                                <!-- Monto -->
                                <td class="text-right">
                                  <div><?php echo number_format($Ven['Total'],2,'.',','); ?></div>
                                </td>
                                <!-- End Monto -->

                                <!-- Destacado --
                                <td>
                                  <?php if( $Ven[Destacado] == 1 ){ ?>
                                    <span class="label label-success">
                                      Destacado
                                    </span>
                                  <?php } ?>
                                </td>
                                <!-- End Destacado -->

                              </tr>
                            <?php } ?>
                          </tbody>
                      </table>
                    </div>
                  </div>
                </div>
                <!-- End Usuarios -->
              </div>
            </div>
        </div>
        <?php require_once($Position.'footer.php'); ?>
      </div>
    </div>
    <?php require_once($Position.'scripts.php'); ?>
    <script>

    </script>
    <script src="<?php echo $Position; ?>assets/plugins/styleswitcher/jQuery.style.switcher.js"></script>

</body>
</html>
